/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.awt.Color;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.blocks.tiles.TileRedstoneBlock;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailability;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.constants.EnumPacketServer;

public class GuiNpcRedstoneBlock
extends GuiNPCInterface
implements IGuiData {
    private static final int minRange = 0;
    private static final int maxRange = 50;
    private final TileRedstoneBlock tile;

    public GuiNpcRedstoneBlock(int x, int y, int z) {
        this.tile = (TileRedstoneBlock)this.player.field_70170_p.func_175625_s(new BlockPos(x, y, z));
        Client.sendData(EnumPacketServer.GetTileEntity, x, y, z);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.tile.isDetailed = button.getValue() == 1;
                this.func_73866_w_();
                break;
            }
            case 4: {
                this.save();
                this.setSubGui(new SubGuiNpcAvailability(this.tile.availability, this));
            }
        }
    }

    @Override
    public void func_73866_w_() {
        GuiNpcTextField textField;
        super.func_73866_w_();
        int color = new Color(0xFFFFFF).getRGB();
        GuiNpcButton button = new GuiNpcButton(4, this.guiLeft + 40, this.guiTop + 20, 120, 20, "availability.options");
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(11, "gui.detailed", this.guiLeft + 40, this.guiTop + 47, color));
        button = new GuiNpcButton(1, this.guiLeft + 110, this.guiTop + 42, 50, 20, new String[]{"gui.no", "gui.yes"}, this.tile.isDetailed ? 1 : 0);
        this.addButton(button);
        if (this.tile.isDetailed) {
            this.addLabel(new GuiNpcLabel(0, new TextComponentTranslation("bard.ondistance", new Object[0]).func_150254_d() + " X:", this.guiLeft + 1, this.guiTop + 76, color));
            textField = new GuiNpcTextField(0, this, this.field_146289_q, this.guiLeft + 80, this.guiTop + 71, 30, 20, this.tile.onRangeX + "");
            textField.setMinMaxDefault(0L, 50L, 6L);
            this.addTextField(textField);
            this.addLabel(new GuiNpcLabel(1, "Y:", this.guiLeft + 113, this.guiTop + 76, color));
            textField = new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + 122, this.guiTop + 71, 30, 20, this.tile.onRangeY + "");
            textField.setMinMaxDefault(0L, 50L, 6L);
            this.addTextField(textField);
            this.addLabel(new GuiNpcLabel(2, "Z:", this.guiLeft + 155, this.guiTop + 76, color));
            textField = new GuiNpcTextField(2, this, this.field_146289_q, this.guiLeft + 164, this.guiTop + 71, 30, 20, this.tile.onRangeZ + "");
            textField.setMinMaxDefault(0L, 50L, 6L);
            this.addTextField(textField);
            this.addLabel(new GuiNpcLabel(3, new TextComponentTranslation("bard.offdistance", new Object[0]).func_150254_d() + " X:", this.guiLeft - 3, this.guiTop + 99, color));
            textField = new GuiNpcTextField(3, this, this.field_146289_q, this.guiLeft + 80, this.guiTop + 94, 30, 20, this.tile.offRangeX + "");
            textField.setMinMaxDefault(0L, 50L, 10L);
            this.addTextField(textField);
            this.addLabel(new GuiNpcLabel(4, "Y:", this.guiLeft + 113, this.guiTop + 99, color));
            textField = new GuiNpcTextField(4, this, this.field_146289_q, this.guiLeft + 122, this.guiTop + 94, 30, 20, this.tile.offRangeY + "");
            textField.setMinMaxDefault(0L, 50L, 10L);
            this.addTextField(textField);
            this.addLabel(new GuiNpcLabel(5, "Z:", this.guiLeft + 155, this.guiTop + 99, color));
            textField = new GuiNpcTextField(5, this, this.field_146289_q, this.guiLeft + 164, this.guiTop + 94, 30, 20, this.tile.offRangeZ + "");
        } else {
            this.addLabel(new GuiNpcLabel(0, "bard.ondistance", this.guiLeft + 1, this.guiTop + 76, color));
            textField = new GuiNpcTextField(0, this, this.field_146289_q, this.guiLeft + 80, this.guiTop + 71, 30, 20, this.tile.onRange + "");
            textField.setMinMaxDefault(0L, 50L, 6L);
            this.addTextField(textField);
            this.addLabel(new GuiNpcLabel(3, "bard.offdistance", this.guiLeft - 3, this.guiTop + 99, color));
            textField = new GuiNpcTextField(3, this, this.field_146289_q, this.guiLeft + 80, this.guiTop + 94, 30, 20, this.tile.offRange + "");
        }
        textField.setMinMaxDefault(0L, 50L, 10L);
        this.addTextField(textField);
        button = new GuiNpcButton(0, this.guiLeft + 40, this.guiTop + 190, 120, 20, "gui.done");
        button.setHoverText("hover.exit", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void save() {
        if (this.tile == null) {
            return;
        }
        if (this.tile.isDetailed) {
            this.tile.onRangeX = this.getTextField(0).getInteger();
            this.tile.onRangeY = this.getTextField(1).getInteger();
            this.tile.onRangeZ = this.getTextField(2).getInteger();
            this.tile.offRangeX = this.getTextField(3).getInteger();
            this.tile.offRangeY = this.getTextField(4).getInteger();
            this.tile.offRangeZ = this.getTextField(5).getInteger();
            if (this.tile.onRangeX > this.tile.offRangeX) {
                this.tile.offRangeX = this.tile.onRangeX;
            }
            if (this.tile.onRangeY > this.tile.offRangeY) {
                this.tile.offRangeY = this.tile.onRangeY;
            }
            if (this.tile.onRangeZ > this.tile.offRangeZ) {
                this.tile.offRangeZ = this.tile.onRangeZ;
            }
        } else {
            this.tile.onRange = this.getTextField(0).getInteger();
            this.tile.offRange = this.getTextField(3).getInteger();
            if (this.tile.onRange > this.tile.offRange) {
                this.tile.offRange = this.tile.onRange;
            }
        }
        NBTTagCompound compound = new NBTTagCompound();
        this.tile.func_189515_b(compound);
        compound.func_82580_o("BlockActivated");
        Client.sendData(EnumPacketServer.SaveTileEntity, compound);
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.tile.func_145839_a(compound);
        this.func_73866_w_();
    }
}

